unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.ExtCtrls, Borland.Vcl.StdCtrls, Borland.Vcl.ComCtrls,
  System.ComponentModel, Borland.Vcl.FileCtrl, Borland.Vcl.Buttons,
  Rejestr, ShellApi, DateUtils, StrUtils, Pliki, FileDetailsStringGrid,
  Printers, Drukowanie;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet4: TTabSheet;
    CheckBox4: TCheckBox;
    Shape1: TShape;
    ColorListBox1: TColorListBox;
    TabSheet5: TTabSheet;
    Label1: TLabel;
    Shape2: TShape;
    TabSheet1: TTabSheet;
    Button17: TButton;
    GroupBox2: TGroupBox;
    Button5: TButton;
    Button4: TButton;
    Button6: TButton;
    Panel2: TPanel;
    Button8: TButton;
    GroupBox1: TGroupBox;
    Button3: TButton;
    Button2: TButton;
    Button1: TButton;
    Button7: TButton;
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    TabSheet2: TTabSheet;
    ComboBox2: TComboBox;
    Button19: TButton;
    Button18: TButton;
    Edit1: TEdit;
    GroupBox3: TGroupBox;
    DriveComboBox1: TDriveComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FilterComboBox1: TFilterComboBox;
    FileListBox1: TFileListBox;
    Label3: TLabel;
    Label2: TLabel;
    GroupBox6: TGroupBox;
    Button22: TButton;
    Button26: TButton;
    GroupBox5: TGroupBox;
    Button21: TButton;
    Button20: TButton;
    Button25: TButton;
    TabSheet3: TTabSheet;
    ControlBar1: TControlBar;
    SpeedButton1: TSpeedButton;
    ComboBox1: TComboBox;
    RichEdit1: TRichEdit;
    Panel3: TPanel;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button14: TButton;
    Button16: TButton;
    Button33: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    FindDialog1: TFindDialog;
    FontDialog1: TFontDialog;
    PrintDialog1: TPrintDialog;
    TabSheet9: TTabSheet;
    Button32: TButton;
    Edit12: TEdit;
    Edit11: TEdit;
    Edit10: TEdit;
    Button31: TButton;
    Edit9: TEdit;
    Edit8: TEdit;
    Edit7: TEdit;
    Edit6: TEdit;
    Edit5: TEdit;
    Edit4: TEdit;
    Button30: TButton;
    Button29: TButton;
    Button28: TButton;
    Edit3: TEdit;
    Label5: TLabel;
    Label4: TLabel;
    TabSheet7: TTabSheet;
    Button23: TButton;
    Button39: TButton;
    TabSheet8: TTabSheet;
    GroupBox4: TGroupBox;
    TreeView1: TTreeView;
    Button24: TButton;
    Edit2: TEdit;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Button27: TButton;
    TabSheet6: TTabSheet;
    Button38: TButton;
    Button37: TButton;
    Button36: TButton;
    Button35: TButton;
    ComboBox3: TComboBox;
    Button34: TButton;
    Image1: TImage;
    procedure FormShow(Sender: TObject);
    procedure Button38Click(Sender: TObject);
    procedure Button36Click(Sender: TObject);
    procedure Button37Click(Sender: TObject);
    procedure Button35Click(Sender: TObject);
    procedure Button34Click(Sender: TObject);
    procedure Button33Click(Sender: TObject);
    procedure Button27Click(Sender: TObject);
    procedure Button24Click(Sender: TObject);
    procedure Button39Click(Sender: TObject);
    procedure Button23Click(Sender: TObject);
    procedure Button26Click(Sender: TObject);
    procedure Button22Click(Sender: TObject);
    procedure Button25Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Button20Click(Sender: TObject);
    procedure Button19Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FileListBox1Change(Sender: TObject);
    procedure Button32Click(Sender: TObject);
    procedure Button31Click(Sender: TObject);
    procedure Button30Click(Sender: TObject);
    procedure Button29Click(Sender: TObject);
    procedure Button28Click(Sender: TObject);
    procedure Edit3KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure RichEdit1Change(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ComboBox1Select(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure FindDialog1Close(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Shape2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Shape2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Shape2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure ColorListBox1Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    //Przeciaganie formy myszka
    CzyKlawiszMyszkiPrzycisniety :Boolean;
    KlawiszMyszkiPrzycisniety_X :Integer;
    KlawiszMyszkiPrzycisniety_Y :Integer;

    //Edytor
    NazwaPliku :String;
    DokumentZmodyfikowany :Boolean;

    //Plik rejestrowania czynnosci
    PlikRejestrowania :TPlikRejestrowania;

    //Watek zapelniajacy TreeView1
    watek :ZapelnijDrzewoWatek;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
const szybkosc=10;
var i :Byte;
begin
ZapiszUstawieniaOkna(Self,'\Software\Helion\Przyklad\Okno',True);

PlikRejestrowania.Dopisz('Zamknicie aplikacji');

if AlphaBlend then
  begin
  i:=AlphaBlendValue;
  repeat
    AlphaBlendValue:=i;
    //Sleep(10);
    Dec(i,szybkosc);
    until i<szybkosc;
    end;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
TransparentColor:=CheckBox4.Checked;
end;

procedure TForm1.ColorListBox1Click(Sender: TObject);
begin
TransparentColorValue:=ColorListBox1.Selected;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
PageControl1.ActivePageIndex:=2;

//Przezroczysty kolor do ColorListBox1
ColorListBox1.Selected:=TransparentColorValue;

//Odczytywanie z rejestru polozenia i rozmiaru okna
CzytajUstawieniaOkna(Self,'\Software\Helion\Przyklad\Okno',False);

//Sprawdzanie zapisu w rejestrze o automatycznym uruchamianiu aplikacji
CheckBox1.Checked:=CzyIstniejeZapisAutostart(Application.Title,HKEY_CURRENT_USER);

//Lista czcionek na zakadce edytora
ComboBox1.Items:=Screen.Fonts;

//Wczytywanie dokumentu podanego jako parametr linii komend
{if ParamCount>0 then
  if FileExists(ParamStr(1)) then
    begin
    NazwaPliku:=ParamStr(1);
    RichEdit1.Lines.LoadFromFile(NazwaPliku);
    Caption:='Edytor - '+NazwaPliku;
    //ShowMessage(NazwaPliku);
    end
    else
    ShowMessage('Plik '+ParamStr(1)+' nie istnieje!');}

DokumentZmodyfikowany:=False;

//Tworzenie obiektu pliku rejestrowania
PlikRejestrowania:=TPlikRejestrowania.Create('Log.txt');
PlikRejestrowania.Dopisz('Uruchomienie aplikacji');

//Wczytywanie nazwy katalogu domowego do Edit2
Edit2.Text:=PobierzSciezkeDoMojeDokumenty;

//Inicjowanie listy drukarek
Button34Click(Self);
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
if Key=Chr(27) then Close;
end;

procedure TForm1.Shape2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if Button=mbLeft then
  begin
  Screen.Cursor:=crHandPoint;
  CzyKlawiszMyszkiPrzycisniety:=True;
  KlawiszMyszkiPrzycisniety_X:=X;
  KlawiszMyszkiPrzycisniety_Y:=Y;
  end;
end;

procedure TForm1.Shape2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var dx,dy :Integer;
begin
if CzyKlawiszMyszkiPrzycisniety then
  begin
  dx:=X-KlawiszMyszkiPrzycisniety_X;
  dy:=Y-KlawiszMyszkiPrzycisniety_Y;
  Form1.Left:=Form1.Left+dx;
  Form1.Top:=Form1.Top+dy;
  end;
end;

procedure TForm1.Shape2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if Button=mbLeft then
  begin
  CzyKlawiszMyszkiPrzycisniety:=False;
  Screen.Cursor:=crArrow;
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
if CheckBox1.Checked then
    ZapiszAutostart(Application.Title,HKEY_CURRENT_USER,Application.ExeName)
    else
    UsunAutostart(Application.Title,HKEY_CURRENT_USER);
end;

procedure TForm1.Button1Click(Sender: TObject);
var strukturaDodajUsun :TDodajUsunInfo;
begin
//Zakladamy, ze Application to aplikacja docelowa (a nie wylacznie instalator)
with strukturaDodajUsun do
  begin
  DisplayName:=Application.Title;
  DisplayIcon:=Application.ExeName;
  DisplayVersion:='1.0';
  Contact:='jacek@phys.uni.torun.pl';
  Publisher:='Helion';
  Comments:='Delphi 2005. 101 praktycznych przykadw';
  URLUpdateInfo:='http://www.phys.uni.torun.pl/~jacek/';
  URLInfoAbout:='http://helion.pl';
  InstallLocation:=ExtractFileDir(Application.ExeName);
  InstallSource:=GetCurrentDir;
  UninstallString:=Application.ExeName+' /uninstall';
  UninstallPath:=Application.ExeName+' /uninstall';
  ModifyPath:=Application.ExeName+' /modify';
  HelpLink:='http://www.phys.uni.torun.pl/~jacek/';
  VersionMajor:=1;
  VersionMinor:=0;
  NoRepair:=1;
  Language:=-1;
  end;

if Sender=Button1 then
  begin
  ShowMessage('Tworz klucz Dodaj/Usu ('+strukturaDodajUsun.DisplayName+')');
  try
    ZapiszDodajUsun(Application.Title,strukturaDodajUsun);
  except
    on exc :Exception do ShowMessage(exc.Message);
  end;
  end;
if Sender=Button2 then
  begin
  ShowMessage('Kasuj klucz Dodaj/Usu ('+strukturaDodajUsun.DisplayName+')');
  UsunDodajUsun(Application.Title);
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var TakNie :String;
begin
TakNie:='nie ';
if CzyIstniejeZapisDodajUsun(Application.Title) then TakNie:='';
ShowMessage('Klucz Dodaj/Usu '+TakNie+'istnieje');
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
ShellExecute(Handle,'open','control.exe','appwiz.cpl','',SW_NORMAL);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
ShowMessage('Moje dokumenty: '+PobierzSciezkeDoMojeDokumenty());
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
ShowMessage('Menu Start\Wszystkie Programy\Autostart: '+Chr(13)+PobierzSciezkeDoKataloguSpecjalnego('Startup'));
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
ShowMessage('Pulpit: '+PobierzSciezkeDoKataloguSpecjalnego('Desktop'));
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
ShellExecute(Handle,'open','regedit.exe','','',SW_NORMAL);
end;

procedure TForm1.Button17Click(Sender: TObject);
begin
  try
    RozszerzMenuKontekstoweIstniejacegoTypuPliku('rtf','edit2','Edytuj w '+Application.Title);
  except
    on e: Exception do ShowMessage(e.Message);
  end;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
OpenDialog1.FileName:=NazwaPliku;
if OpenDialog1.Execute then
  begin
  NazwaPliku:=OpenDialog1.FileName;
  RichEdit1.PlainText:=(ExtractFileExt(NazwaPliku)='.txt') or (ExtractFileExt(NazwaPliku)='.pas');
  RichEdit1.Lines.LoadFromFile(NazwaPliku);
  Form1.Caption:='Edytor - '+ExtractFileName(NazwaPliku);
  DokumentZmodyfikowany:=False;
  end;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
SaveDialog1.FileName:=NazwaPliku;
if SaveDialog1.Execute then
  begin
  NazwaPliku:=SaveDialog1.FileName;
  RichEdit1.Lines.SaveToFile(NazwaPliku);
  Form1.Caption:='Edytor - '+ExtractFileName(NazwaPliku);
  DokumentZmodyfikowany:=False;
  end;
end;

procedure TForm1.Button12Click(Sender: TObject);
var LokalnaNazwaPliku :String;
begin
SaveDialog1.FileName:=NazwaPliku;
if SaveDialog1.Execute then
  begin
  LokalnaNazwaPliku:=SaveDialog1.FileName;
  RichEdit1.Lines.SaveToFile(LokalnaNazwaPliku);
  end;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
if NazwaPliku<>'' then
                  begin
                  RichEdit1.Lines.SaveToFile(NazwaPliku);
                  DokumentZmodyfikowany:=False;
                  end
                  else Button11Click(Self);
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
RichEdit1.SelLength:=0;
FindDialog1.Execute;
(Sender as TButton).Enabled:=False;
end;

procedure TForm1.FindDialog1Find(Sender: TObject);
var
  poczatek, dlugosc, pozycja :Integer;
  opcje :TSearchTypes;
begin
  with RichEdit1 do
  begin
    if SelLength=0 then
      begin //pierwszy raz
      poczatek:=SelStart; //pozycja kursora
      dlugosc:=Length(Text)-poczatek;
      end
      else //szukanie nastepnego (zaznaczony fragment)
      begin
      poczatek:=SelStart+SelLength;
      dlugosc:=Length(Text)-poczatek;
      end;

    if frMatchCase in FindDialog1.Options then Include(opcje,stMatchCase);
    if frWholeWord in FindDialog1.Options then Include(opcje,stWholeWord);
    pozycja:=FindText(FindDialog1.FindText,poczatek,dlugosc,opcje);

    if pozycja>=0 then
      begin
      SelStart:=pozycja;
      SelLength:=Length(FindDialog1.FindText);
      end
      else
      begin
      ShowMessage('Zakoczono przeszukiwanie dokumentu. Fragment "'+FindDialog1.FindText+'" nie zosta znaleziony');
      FindDialog1.CloseDialog;
      end;
  end;
end;

procedure TForm1.FindDialog1Close(Sender: TObject);
begin
Button14.Enabled:=True;
end;

procedure TForm1.Button16Click(Sender: TObject);
begin
if RichEdit1.SelLength=0 then
  begin
  ShowMessage('Zaznacz fragment tekstu');
  Exit;
  end;

FontDialog1.Font.Assign(RichEdit1.SelAttributes);
if FontDialog1.Execute then
  RichEdit1.SelAttributes.Assign(FontDialog1.Font);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var styl :TFontStyles;
begin
styl:=RichEdit1.SelAttributes.Style;
if SpeedButton1.Down then Include(styl,fsBold) else Exclude(styl,fsBold);
RichEdit1.SelAttributes.Style:=styl;
end;

procedure TForm1.ComboBox1Select(Sender: TObject);
begin
RichEdit1.SelAttributes.Name:=ComboBox1.Text;
end;

procedure TForm1.RichEdit1Change(Sender: TObject);
begin
if not DokumentZmodyfikowany then Form1.Caption:=Form1.Caption+' (Zmodyfikowany)';
DokumentZmodyfikowany:=True;
RichEdit1.ScrollBars:=ssBoth;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var przycisk :Integer;
begin
if DokumentZmodyfikowany then
  begin
  przycisk:=Application.MessageBox('Dokument zosta zmieniony. Czy zapisa zmiany?',Form1.Caption,MB_YESNOCANCEL);
  case przycisk of
    ID_YES:
      if NazwaPliku<>'' then RichEdit1.Lines.SaveToFile(NazwaPliku)
                        else Button11Click(Self); //Wywolanie metody zapisujacej zmiany do pliku wskazanego przez uzytkownika
    ID_CANCEL: CanClose:=False;
    //ID_NO: ShowMessage('Zmiany nie zostan zachowane');
    end;
  end;
end;

{procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
const przyrost=0.1;
var
  v :Extended;
  EditSender :TEdit;
begin
if (Key=VK_UP) or (Key=VK_DOWN) then
  begin
  EditSender:=Sender as TEdit;
  if EditSender.ReadOnly then Exit;
  v:=StrToFloat(EditSender.Text);
  case Key of
    VK_UP: v:=v+przyrost;
    VK_DOWN: v:=v-przyrost;
    end;
  EditSender.Text:=FloatToStr(v);
  end;
end;}

{procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
const przyrost=0.1;
var
  v :Extended;
  EditSender :TEdit;
  ustawienia :TFormatSettings;
begin
if (Key=VK_UP) or (Key=VK_DOWN) then
  begin
  EditSender:=Sender as TEdit;
  if EditSender.ReadOnly then Exit;

  GetLocaleFormatSettings(LOCALE_SYSTEM_DEFAULT,ustawienia);
  ustawienia.DecimalSeparator:='.';

  v:=StrToFloat(EditSender.Text,ustawienia);
  case Key of
    VK_UP: v:=v+przyrost;
    VK_DOWN: v:=v-przyrost;
    end;
  EditSender.Text:=FloatToStr(v,ustawienia);
  end;
end;}

procedure TForm1.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
const przyrost=1;
var
  v :Integer;
  EditSender :TEdit;
begin
if (Key=VK_UP) or (Key=VK_DOWN) then
  begin
  EditSender:=Sender as TEdit;
  if EditSender.ReadOnly then Exit;
  v:=StrToInt(EditSender.Text);
  case Key of
    VK_UP: Inc(v,przyrost);
    VK_DOWN: Dec(v,przyrost);
    end;
  EditSender.Text:=IntToStr(v);
  end;
end;


procedure TForm1.Button28Click(Sender: TObject);
const miesiace :array[1..12] of string = ('stycznia','lutego','marca','kwietnia','maja','czerwca','lipca','sierpnia','wrzenia','padziernika','listopada','grudnia');
var
  ustawienia :TFormatSettings;
  w :String;
  i :Byte;
begin
GetLocaleFormatSettings(LOCALE_SYSTEM_DEFAULT,ustawienia);

w:='Przykady formatowania daty:'+#13+#13;

ustawienia.ShortDateFormat:='dd-mm-yyyy';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='dd/mm/yyyy';
ustawienia.DateSeparator:='/';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='yyyy-mm-dd';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='yyyy';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='yy';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='d-m-y';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='d mmmm yyyy';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='d mmmm yyyy';
for i:=1 to 12 do ustawienia.LongMonthNames[i]:=miesiace[i];
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='dddd';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ustawienia.ShortDateFormat:='d mmmm yyyy (dddd)';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;

ShowMessage(w);
end;

procedure TForm1.Button29Click(Sender: TObject);
var
  ustawienia :TFormatSettings;
  w :String;
begin
GetLocaleFormatSettings(LOCALE_SYSTEM_DEFAULT,ustawienia);

w:='Przykady formatowania czasu:'+#13+#13;

ustawienia.LongTimeFormat:='t';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ustawienia.LongTimeFormat:='hh:mm';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ustawienia.LongTimeFormat:='h:mm';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ustawienia.LongTimeFormat:='hh:mm:ss.zzz';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ustawienia.LongTimeFormat:='hh:mm:sszzz';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ustawienia.LongTimeFormat:='hh\mm\ss';
w:=w+'Format: '+ustawienia.LongTimeFormat+', czas: '+TimeToStr(Now,ustawienia)+#13;

ShowMessage(w);
end;

procedure TForm1.Button30Click(Sender: TObject);
var
  ustawienia :TFormatSettings;
  w :String;
begin
w:='Dzie tygodnia:'+#13+#13;

{GetLocaleFormatSettings(LOCALE_SYSTEM_DEFAULT,ustawienia);
ustawienia.ShortDateFormat:='dddd (dd-mm-yyyy)';
w:=w+'Format: '+ustawienia.ShortDateFormat+', data: '+DateToStr(Now,ustawienia)+#13;}

w:=w+'DayOfWeek: '+IntToStr(DayOfWeek(Now))+#13;
w:=w+'DayOfTheWeek: '+IntToStr(DayOfTheWeek(Now))+#13;

ShowMessage(w);
end;

procedure TForm1.Button31Click(Sender: TObject);
var
  rok,miesiac,dzien,dzienTygodnia :Word;
  godzina,minuty,sekundy,milisekundy :Word;
begin
DecodeDateFully(Now,rok,miesiac,dzien,dzienTygodnia);
Edit4.Text:=IntToStr(dzien);
Edit5.Text:=IntToStr(miesiac);
Edit6.Text:=IntToStr(rok);
Edit7.Text:=IntToStr(dzienTygodnia);

DecodeTime(Now,godzina,minuty,sekundy,milisekundy);
Edit8.Text:=IntToStr(godzina);
Edit9.Text:=IntToStr(minuty);
Edit10.Text:=IntToStr(sekundy);
Edit11.Text:=IntToStr(milisekundy);
end;

procedure TForm1.Button32Click(Sender: TObject);
var w :String;
begin
w:='Zmiana liter na due w acuchu: '+Edit12.Text+#13+#13;

w:=w+'UpperCase: '+UpperCase(Edit12.Text)+#13;
w:=w+'WideUpperCase: '+WideUpperCase(Edit12.Text)+#13;
w:=w+'AnsiUpperCase: '+AnsiUpperCase(Edit12.Text)+#13;

ShowMessage(w);
end;

procedure TForm1.FileListBox1Change(Sender: TObject);
begin
Label3.Caption:=FileListBox1.FileName;
end;

procedure TForm1.FileListBox1DblClick(Sender: TObject);
var
  NowyKatalog :String;
  Poczatek,Dlugosc :Integer;
begin
NowyKatalog:=ExtractFileName(FileListBox1.FileName); //Nazwa katalogu z []
NowyKatalog:=MidStr(NowyKatalog,2,Length(NowyKatalog)-2); //Pozbywamy sie nawiasow kwadratowych
if DirectoryExists(NowyKatalog) then
  FileListBox1.Directory:=NowyKatalog;
end;

procedure TForm1.Button18Click(Sender: TObject);
begin
ZapiszDoPlikuTekstowego('Plik.txt',FileListBox1.Items);
end;

procedure TForm1.Button19Click(Sender: TObject);
var linie :TStrings;
begin
linie:=CzytajZPlikuTekstowego('Plik.txt');
ComboBox2.Items.AddStrings(linie);
linie.Free;
ComboBox2.ItemIndex:=0;
end;

procedure TForm1.Button20Click(Sender: TObject);
begin
if not CopyFile('Log.txt','Log.bak',False) then ShowMessage('Operacja nie powioda si');
end;

procedure TForm1.Button21Click(Sender: TObject);
begin
if not MoveFile('Log.txt','Log_nowy.txt') then ShowMessage('Operacja nie powioda si');
end;

procedure TForm1.Button25Click(Sender: TObject);
var plik :TextFile;
begin
//WinAPI
//if not DeleteFile('Log.txt') then ShowMessage('Operacja nie powioda si');

//Pascal
AssignFile(plik,'Log.txt');
Erase(plik);
end;

procedure TForm1.Button22Click(Sender: TObject);
var
  nazwaPliku :String;
  sr :TSearchRec;
  informacje :TStrings;
  systemowaDataUtworzenia,lokalnaDataUtworzenia :TSystemTime;
  systemowaDataOstatniegoDostepu,lokalnaDataOstatniegoDostepu :TSystemTime;
begin
if FileListBox1.FileName='' then
  begin
  ShowMessage('Wska nazw pliku w komponencie FileListBox1!');
  Exit;
  end;

nazwaPliku:=FileListBox1.FileName;
ShowMessage('Badam wasnoci pliku: '+nazwaPliku);
if FindFirst(nazwaPliku, faAnyFile, sr)<>0 then
begin
  ShowMessage('Odnalezienie pliku nie powiodo si!');
  Exit;
  end;

FindClose(sr);

informacje:=TStringList.Create;
informacje.Add('Nazwa (duga): '+sr.Name);
informacje.Add('Nazwa (8.3): '+sr.FindData.cAlternateFileName);
informacje.Add('Rozmiar: '+IntToStr(sr.Size)+' bajtw');
informacje.Add('Atrybuty: '+IntToStr(sr.Attr));
informacje.Add('Data ostatniej modyfikacji: '+DateTimeToStr(FileDateToDateTime(sr.Time)));

//Konwersja formatu daty
FileTimeToSystemTime(sr.FindData.ftCreationTime,systemowaDataUtworzenia);
SystemTimeToTzSpecificLocalTime(nil,systemowaDataUtworzenia,lokalnaDataUtworzenia);
informacje.Add('Data utworzenia: '+DateTimeToStr(SystemTimeToDateTime(lokalnaDataUtworzenia)));

FileTimeToSystemTime(sr.FindData.ftLastAccessTime,systemowaDataOstatniegoDostepu);
SystemTimeToTzSpecificLocalTime(nil,systemowaDataOstatniegoDostepu,lokalnaDataOstatniegoDostepu);
informacje.Add('Data ostatniego dostpu: '+DateTimeToStr(SystemTimeToDateTime(lokalnaDataOstatniegoDostepu)));

ShowMessage(informacje.Text);
end;

procedure TForm1.Button26Click(Sender: TObject);
var n,w :String;
begin
//s:=Application.ExeName;
n:=FileListBox1.FileName;
if n='' then
  begin
  ShowMessage('Wska nazw pliku w komponencie FileListBox1');
  Exit;
  end;

w:='Pena nazwa pliku: '+n+#13;
w:=w+'Nazwa katalogu: '+ExtractFileDir(n)+#13;
w:=w+'Nazwa pliku: '+ExtractFileName(n)+#13;
w:=w+'Symbol dysku: '+ExtractFileDrive(n)+#13;
w:=w+'Rozszerzenie pliku: '+ExtractFileExt(n)+#13;
w:=w+'Wzgldna cieka: '+ExtractRelativePath(GetCurrentDir,n)+#13;
w:=w+'Pena nazwa pliku w formacie 8.3: '+ExtractShortPathName(n)+#13;

ShowMessage(w);
end;

procedure TForm1.Button23Click(Sender: TObject);
var
  fdsg :TFileDetailsStringGrid;
  podloze :TWinControl;
begin
(Sender as TButton).Hide;

//podloze:=Form1;
podloze:=TabSheet7;
//fdsg:=TFileDetailsStringGrid.Create(podloze,'.','*.*');
fdsg:=TFileDetailsStringGrid.Create(podloze);
fdsg.Parent:=podloze;
fdsg.Align:=alClient;

fdsg.Directory:='C:\WINDOWS';
fdsg.Mask:='*.exe';

ShowMessage('Zaznaczony plik: '+fdsg.Filename+#13+
            'Wielko plik w ostatnim wierszu: '+IntToStr(fdsg.GetFileDetails(fdsg.RowCount-1).Size));
end;

{procedure TForm1.Button39Click(Sender: TObject);
var
  l :Char;
  p :Integer;
  sp,s :String;
begin
s:='';
for l:='c' to 'z' do
  begin
  if DiskSize(l)<=0 then continue;
  p:=(10000*DiskFree(l)) div DiskSize(l);
  sp:=FloatToStr(100-p/100);
  s:=s+'Ilo zajtego miejsca na dysku '+UpperCase(l)+': to '+sp+'%'+#13;
  end;

ShowMessage(s);
end;}

procedure TForm1.Button39Click(Sender: TObject);
var
  l :Char;
  i :Byte;
  p :Integer;
  sp,s :String;
begin
s:='';
for l:='c' to 'z' do
  begin
  i:=Ord(l)-Ord('a')+1;
  if DiskSize(i)<=0 then continue;
  p:=(10000*DiskFree(i)) div DiskSize(i);
  sp:=FloatToStr(100-p/100);
  s:=s+'Ilo zajtego miejsca na dysku '+UpperCase(l)+': to '+sp+'%'+#13;
  end;

ShowMessage(s);
end;


procedure TForm1.Button24Click(Sender: TObject);
begin
Screen.Cursor:=crHourGlass;
TreeView1.Items.Clear;
ZapelnijDrzewo(TreeView1,nil,Edit2.Text,CheckBox5.Checked,CheckBox6.Checked);
Screen.Cursor:=crDefault;
end;


procedure TForm1.Button27Click(Sender: TObject);
begin
watek:=ZapelnijDrzewoWatek.Create(TreeView1,nil,Edit2.Text,CheckBox5.Checked,CheckBox6.Checked);
end;

procedure TForm1.Button33Click(Sender: TObject);
begin
if PrintDialog1.Execute then
  RichEdit1.Print('Drukowanie dokumentu '+NazwaPliku);
end;

procedure TForm1.Button34Click(Sender: TObject);
begin
ComboBox3.Items:=Printer.Printers;
ComboBox3.ItemIndex:=Printer.PrinterIndex;
end;

procedure TForm1.Button35Click(Sender: TObject);
var
  tekst :TStringList;
  czcionka :TFont;
  strony :Integer;
begin
tekst:=TStringList.Create;
tekst.Add('Czcionki ekranowe:');
tekst.AddStrings(Screen.Fonts);
tekst.Add('');
tekst.Add('Czcionki drukarki:');
tekst.AddStrings(Printer.Fonts);
ShowMessage('Ilo linii: '+IntToStr(tekst.Count));


czcionka:=TFont.Create;
czcionka.Assign(Printer.Canvas.Font);
czcionka.Size:=12;
czcionka.Name:='Times New Roman';
czcionka.Color:=clNavy;
strony:=Drukuj(tekst,czcionka,False);
ShowMessage('Wydrukowano '+IntToStr(strony)+' stron');
end;

procedure TForm1.Button37Click(Sender: TObject);
const filtrObrazy='Bitmapy i ikony (*.bmp;*.ico)|*.bmp;*.ico|Wszystkie pliki (*.*)|*.*';
var filtrTeksty :String;
begin
filtrTeksty:=OpenDialog1.Filter;
OpenDialog1.Filter:=filtrObrazy;

if OpenDialog1.Execute then
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);

OpenDialog1.Filter:=filtrTeksty;
end;

procedure TForm1.Button36Click(Sender: TObject);
begin
//ShowMessage('Drukuje obraz o rozmiarze '+IntToStr(Image1.Picture.Graphic.Width)+' x '+IntToStr(Image1.Picture.Graphic.Height));
Drukuj(Image1.Picture.Graphic,True,False);
end;

procedure TForm1.Button38Click(Sender: TObject);
var tekst :TStringList;
begin
tekst:=TStringList.Create;
tekst.Add('Czcionki ekranowe:');
tekst.AddStrings(Screen.Fonts);
tekst.Add('');
tekst.Add('Czcionki drukarki:');
tekst.AddStrings(Printer.Fonts);
ShowMessage('Ilo linii: '+IntToStr(tekst.Count));

DrukujTekstowo(tekst);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
//Wczytywanie dokumentu podanego jako parametr linii komend
if RichEdit1.Tag=0 then
  begin
  RichEdit1.Tag:=1;
  if ParamCount>0 then
    if FileExists(ParamStr(1)) then
      begin
      NazwaPliku:=ParamStr(1);
      RichEdit1.Lines.LoadFromFile(NazwaPliku);
      Caption:='Edytor - '+NazwaPliku;
      //ShowMessage(NazwaPliku);
      end
      else
      ShowMessage('Plik '+ParamStr(1)+' nie istnieje!');
  end;

DokumentZmodyfikowany:=False;
end;

end.
